<?php
/*
Plugin Name: Construction Theme - Functionality
Plugin URI:  https://themeforest.net/user/sk-themes/
Description: Adds functionality to SK-Themes
Version:     3.8
Author:      SK Web Solutions
Author URI:  https://sk-web-solutions.com/
License:     GPL2
*/

Class Construction_Functionality {

	/**
     * Constructor
     *
     * @since 1.0
     *
    */
    public function __construct(){
        
        $this->construction_constants();
    	$this->construction_inc_files();
        
        add_action( 'plugins_loaded', array( &$this, 'construction_plugins_loaded' ), 9 );        
    }

    /**
     * Define constants
     *
     * @since 1.0
     *
    */
    protected function construction_constants(){
        
        /**
         * Plugin Path
         */
        define( 'CONSTRUCTION_FUNC_PATH', plugin_dir_path( __FILE__ ) );

    }

    /**
     * include files
     *
     * @since 1.0
     *
    */
    function construction_inc_files(){

        $fave_theme_name = (wp_get_theme()->Name);

        if( $fave_theme_name == 'Construction' || $fave_theme_name == 'Construction Child' ){
            
            // Custom Post Types
            require_once( CONSTRUCTION_FUNC_PATH . 'post-types/service-post-type.php' );
            require_once( CONSTRUCTION_FUNC_PATH . 'post-types/project-post-type.php' );
            
            if( !class_exists('RW_Meta_Box') ){
                require_once( CONSTRUCTION_FUNC_PATH . 'framework/meta-box/meta-box.php');
                require_once( CONSTRUCTION_FUNC_PATH . 'framework/meta-box/construction-meta-boxes.php');
            }

            // Redux Framework
            if( !class_exists('ReduxFramework') ){
                require_once( CONSTRUCTION_FUNC_PATH . 'framework/ReduxCore/framework.php');
            }

            // Add widget
            require_once( CONSTRUCTION_FUNC_PATH . 'functions/widgets/recent-blog.php' );
            require_once( CONSTRUCTION_FUNC_PATH . 'functions/widgets/latest-project.php' );
            require_once( CONSTRUCTION_FUNC_PATH . 'functions/widgets/social-networks.php' );

            add_action( 'plugins_loaded', 'construction_init_vendor_woocommerce' );
            function construction_init_vendor_woocommerce() {
                include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
                if( is_plugin_active( 'woocommerce/woocommerce.php' ) || class_exists( 'WooCommerce' ) ){
                    require_once( CONSTRUCTION_FUNC_PATH . 'functions/widgets/woocommerce-header-cart.php' );
                }
            }

            // Visual Composer
            add_action( 'plugins_loaded', 'shortcodes_init' );
            function shortcodes_init() {
                foreach( glob( plugin_dir_path( __FILE__ ) . '/framework/visual-composer/*.php' ) as $filename ){
                    require_once $filename;
                }
            }

        } // End theme check
    }

    /**
     * Callback function WP plugin_loaded action hook. Loads lang
     *
     * @since  1.0
     * @access public
     */
    public function construction_plugins_loaded(){
        load_plugin_textdomain( 'construction', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }

}

/**
 * Instantiate the Class
 *
 * @since     1.0
 * @global    object
 */
$construction_functionality = new Construction_Functionality();

if( ! function_exists( 'construction_title' ) ){
    function construction_title( $title )   {
        $seo_title = get_post_meta( construction_get_page_id(), "page_seo_title", true );
        if( !empty( $seo_title ) ){
            if( trim( $seo_title ) ){
                $title = esc_html( $seo_title );
            }
        }        
        return $title;
    }
}
add_filter( 'pre_get_document_title', 'construction_title' );

if( !function_exists('construction_header_meta') ){
    
    // Function that echoes meta data if our seo is enabled
    function construction_header_meta(){
        
        if( !function_exists('_wp_render_title_tag') ){ ?>
            <title><?php wp_title(''); ?></title><?php
        }

        global $construction_options;

        $seo_description    = get_post_meta( construction_get_page_id(), "page_seo_description", true );
        $seo_keywords       = get_post_meta( construction_get_page_id(), "page_seo_keywords", true );

        if( $seo_description ){ ?>
            <meta name="description" content="<?php echo esc_html($seo_description); ?>">
        <?php } else if( isset($construction_options['theme_meta_description']) ){ ?>
            <meta name="description" content="<?php echo esc_html($construction_options['theme_meta_description']) ?>">
        <?php } ?>

        <?php if( $seo_keywords ){ ?>
            <meta name="keywords" content="<?php echo esc_html($seo_keywords); ?>">
        <?php } else if( isset($construction_options['theme_meta_keyword']) ){ ?>
            <meta name="keywords" content="<?php echo esc_html($construction_options['theme_meta_keyword']) ?>">
        <?php }
        
        if( isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false ) )
            echo( '<meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">' );
        ?>

        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" /><?php
    }

    add_action( 'construction_header_meta', 'construction_header_meta' );
}

?>