<?php

// General metabox option of page or post
$meta_boxes[] = array(

    'id'        => 'page_general',    
    'title'     => esc_html__('General Option', 'construction' ),    
    'pages'     => array( 'page', 'post', 'service', 'project', 'product' ),
    'context'   => 'normal',
    'fields'    => array(

        array(
            'name'  => esc_html__( 'Content Background Color:', 'construction' ),
            'desc'  => esc_html__( 'Choose the content background color', 'construction' ),
            'id'    => 'page_content_bk_color',
            'type'  => 'color',
        ),

        array(
            'name'  => esc_html__( 'Body Background Color:', 'construction' ),
            'desc'  => esc_html__( 'Choose the body background color', 'construction' ),
            'id'    => 'page_body_bk_color',
            'type'  => 'color',
        ),

        array(
            'name'              => esc_html__( 'Body Background Image:', 'construction' ),
            'desc'              => esc_html__( 'Choose the body background image', 'construction' ),
            'id'                => 'page_body_bk_image',
            'type'              => 'image_advanced',
            'max_file_uploads'  => 1,
        ),

        array(
            'name'          => esc_html__( '100% Background Image:', 'construction' ),
            'id'            => 'page_body_bk_image_100',
            'desc'          => esc_html__( 'Choose the 100% background image option', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                'yes' => esc_html__( 'Yes', 'construction' ),
                                'no' => esc_html__( 'No', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'construction' ),
        ),

        array(
            'name'          => esc_attr__( 'Background Repeat:', 'construction' ),
            'id'            => 'page_body_bk_image_repeat',
            'desc'          => esc_html__( 'Choose the background image repeat option', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                '0' => esc_attr__( 'No repeat', 'construction' ),
                                '1' => esc_attr__( 'Repeat both vertically and horizontally', 'construction' ),
                                '2' => esc_attr__( 'Repeat only horizontally', 'construction' ),
                                '3' => esc_attr__( 'Repeat only vertically', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'construction' ),
        ),
    )
);

?>