<?php

// Header metabox option of page or post
$meta_boxes[] = array(

    'id'        => 'page_header',    
    'title'     => esc_html__('Header Option', 'construction' ),    
    'pages'     => array( 'page', 'post', 'service', 'project', 'product' ),
    'context'   => 'normal',
    'fields'    => array(

        array(
            'name'          => esc_html__( 'Show Top Bar:', 'construction' ),
            'id'            => 'page_show_top_bar',
            'desc'          => esc_html__( 'Enabling this option will show header on your page', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                'yes' => esc_html__( 'Yes', 'construction' ),
                                'no' => esc_html__( 'No', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'easyweb' ),
        ),

        array(
            'name'          => esc_html__( 'Show Page Menu:', 'construction' ),
            'id'            => 'page_show_menu',
            'desc'          => esc_html__( 'Enabling this option will show header on your page', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                'yes' => esc_html__( 'Yes', 'construction' ),
                                'no' => esc_html__( 'No', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'easyweb' ),
        ),

        array(
            'name'          => esc_html__( 'Sticky Header:', 'construction' ),
            'id'            => 'header_sticky_on_scroll',
            'desc'          => esc_html__( 'Enabling this option it will be displayed when the user scrolls down the page', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                'yes' => esc_html__( 'Yes', 'construction' ),
                                'no' => esc_html__( 'No', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'easyweb' ),
        ),

        array(
            'name'          => esc_html__( 'Show Title Area:', 'construction' ),
            'id'            => 'page_show_title_area',
            'desc'          => esc_html__( 'Disabling this option will turn off page title area', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                'yes' => esc_html__( 'Yes', 'construction' ),
                                'no' => esc_html__( 'No', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'easyweb' ),
        ),

        array(
            'name'          => esc_html__( 'Show Page Title:', 'construction' ),
            'id'            => 'page_show_title',
            'desc'          => esc_html__( 'Enabling this option will show title on your page', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                'yes' => esc_html__( 'Yes', 'construction' ),
                                'no' => esc_html__( 'No', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'easyweb' ),
        ),

        array(
            'name'          => esc_html__( 'Show Breadcrumbs:', 'construction' ),
            'id'            => 'page_show_breadcrumbs',
            'desc'          => esc_html__( 'Enabling this option will show Breadcrumbs on your page', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                'yes' => esc_html__( 'Yes', 'construction' ),
                                'no' => esc_html__( 'No', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'easyweb' ),
        ),

        array(
            'name'              => esc_html__( 'Page Banner Image:', 'construction' ),
            'desc'              => esc_html__( 'Choose the page banner image', 'construction' ),
            'id'                => 'page_banner_image',
            'type'              => 'image_advanced',
            'max_file_uploads'  => 1,                
        ),
        
    )
);

?>