<?php

$sidebar_type = array();
$sidebar_type['global'] = esc_html__( 'Global', 'construction' );
foreach( $GLOBALS['wp_registered_sidebars'] as $sidebar ){
    $sidebar_type[$sidebar['id']] = ucwords( $sidebar['name'] );
}

// Sidebar metabox option of page or post
$meta_boxes[] = array(

    'id'        => 'page_sidebar',
    'title'     => esc_html__('Sidebar Option', 'construction' ),    
    'pages'     => array( 'page', 'post', 'service', 'project', 'product' ),
    'context'   => 'normal',
    'fields'    => array(

        array(
            'name'          => esc_html__( 'Layout:', 'construction' ),
            'id'            => 'page_sidebar_layout',
            'desc'          => esc_html__( 'Choose the sidebar layout', 'construction' ),
            'type'          => 'select',
            'options'       => array(
                                'global' => esc_html__( 'Global', 'construction' ),
                                'none' => esc_html__( 'No Sidebar', 'construction' ),
                                'default' => esc_html__( 'Default', 'construction' ),
                                '1' => esc_html__( 'Sidebar 1/3 right', 'construction' ),
                                '2' => esc_html__( 'Sidebar 1/4 right', 'construction' ),
                                '3' => esc_html__( 'Sidebar 1/3 left', 'construction' ),
                                '4' => esc_html__( 'Sidebar 1/4 left', 'construction' ),
                            ),
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'construction' ),
        ),

        array(
            'name'          => esc_html__( 'Choose Widget Area in Sidebar:', 'construction' ),
            'id'            => 'page_sidebar_widget',
            'desc'          => esc_html__( 'Choose Custom Widget area to display in Sidebar', 'construction' ),
            'type'          => 'select',
            'options'       => $sidebar_type,
            'std'           => 'global',
            'placeholder'   => esc_attr__( 'Select an Item', 'construction' ),
        ),
    )
);

?>