<?php

function construction_accordions_shortcode( $atts, $content = null ) {

	extract( shortcode_atts( array(
		'active_section' 	=> '',
		'accordion' 		=> '',
	), $atts ) );

	ob_start();

	echo '<div class="accordion_container">';

	$accordion = (array) vc_param_group_parse_atts( $accordion );
	
	if( !empty($accordion) ){
		$counter = 1;
		foreach ( $accordion as $data ) :
			$active_style = '';
			$active_sign = '-';
			if( $active_section == 'enable' ){
				if( $counter != 1 ){
					$active_style = 'display: none;';
					$active_sign = '+';
				}
			}
			echo '
			<div class="accordion_head">
				'.sprintf( esc_html__( '%s', 'construction' ), $data['accordion_title'] ).'
				<span class="plusminus">'.$active_sign.'</span>
			</div>
            <div class="accordion_body" style="'.esc_attr( $active_style ).'">
            	<p>'.sprintf( esc_html__( '%s', 'construction' ), $data['accordion_content'] ).'</p>
            </div>';
            $counter++;
		endforeach;
	}

	echo '</div>';

	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}

add_shortcode( 'accordions', 'construction_accordions_shortcode' );

?>