<?php

// Construction button shortcode
function construction_button_shortcode( $atts, $content = null ){	
	// Extract button value
	extract( shortcode_atts( array(
		'button_shape' 				=> '',
		'button_content'			=> '',		
		'button_url'				=> '',
		'button_target'				=> '',
		'button_size'				=> '',
		'position'					=> 'left',
		'button_text_color' 		=> '',
		'button_color' 				=> '',
		'hover_button_text_color' 	=> '',
		'hover_button_color' 		=> '',
		'button_border_color' 		=> '',
		'hover_button_border_color' => '',
	), $atts ) );

	$id = uniqid(rand());

	ob_start();

	// Button element is ready to show
	echo '<div class="text-'.esc_attr($position).' '.esc_attr($position).' mvb-button"><a href="'.esc_url( $button_url ).'" class="btn-orange btn-white btn-shape-'.esc_attr( $button_shape ).' btn-size-'.esc_attr( $button_size ).'" target="'.esc_attr( $button_target ).'" id="construction-'.$id.'">'.sprintf( esc_html__( '%s', 'construction' ), $button_content ).'</a></div>';
	
	$button_style = $button_style1 = $button_style_hover = '';

	if( $button_text_color != '' ){
		$button_style .= 'color:'.$button_text_color.' !important;';
	}

	if( $button_color != '' ){
		$button_style1 .= 'background:'.$button_color.' none repeat scroll 0 0 !important;';		
	}

	if( $button_border_color != '' ){
		$button_style1 .= 'border:2px solid '.$button_border_color.' !important;';
	}

	if( $hover_button_text_color != '' ){
		$button_style_hover .= 'color:'.$hover_button_text_color.' !important;';
	}

	if( $hover_button_color != '' ){
		$button_style_hover .= 'background:'.$hover_button_color.' none repeat scroll 0 0 !important;';
	}

	if( $hover_button_border_color != '' ){
		$button_style_hover .= 'border:2px solid '.$hover_button_border_color.' !important;';
	}

	if( !empty($button_style) || !empty($button_style_hover) ){
		echo '<style>';
			if( !empty($button_style) ){
				echo 
				'#construction-'.$id.',
				#construction-'.$id.'.btn-orange:before{
					'.$button_style.'
				}';
			}
			if( !empty($button_style1) ){
				echo 
				'#construction-'.$id.'.btn-orange:before{
					'.$button_style1.'
				}';
			}
			if( !empty($button_style_hover) ){
				echo 
				'#construction-'.$id.':hover{
					'.$button_style_hover.'
				}';
			}
		echo '</style>';
	}

	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'button', 'construction_button_shortcode' );

?>