<?php

// Construction document shortcode
function construction_document_shortcode( $atts, $content = null ){	
	// Extract document value
	extract( shortcode_atts( array(
		'link_style' 	=> '1',
		'link_text'		=> '',		
		'link_url'		=> '',
		'link_target'	=> '',
		'position'		=> 'left',
		'icon_name'		=> '',
	), $atts ) );

	ob_start();

	$icon = '';

	if( !empty( $icon_name ) && $icon_name != 'none' ){
		$icon = do_shortcode( "[icon name='$icon_name']" );
	}

	// document element is ready to show
	if( $link_style == 2 ){		
		if( $position == 'left' ){
			echo '<a href="'.esc_url( $link_url ).'" class="a-orange-button" target="'.esc_attr( $link_target ).'">'. $icon .' '.sprintf( esc_html__( '%s', 'construction' ), $link_text ).'</a>';
		} else {
			echo '<a href="'.esc_url( $link_url ).'" class="a-orange-button" target="'.esc_attr( $link_target ).'">'.sprintf( esc_html__( '%s', 'construction' ), $link_text ).' '. $icon .'</a>';
		}		
	} else {
		if( $position == 'left' ){
			echo '<a href="'.esc_url( $link_url ).'" class="a-document-link" target="'.esc_attr( $link_target ).'">'. $icon .' '.sprintf( esc_html__( '%s', 'construction' ), $link_text ).'</a>';
		} else {
			echo '<a href="'.esc_url( $link_url ).'" class="a-document-link" target="'.esc_attr( $link_target ).'">'.sprintf( esc_html__( '%s', 'construction' ), $link_text ).' '. $icon .'</a>';
		}
	}
	
	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'document', 'construction_document_shortcode' );

?>