<?php

function construction_gallery_shortcode( $atts, $content = null ){

    extract( shortcode_atts( array(
        'gallery_style'     => '',
        'gallery_image'     => '',
        'image_per_view'    => '',
    ), $atts) );

    ob_start();

    if( $gallery_style == 1 ){
        if( !empty($gallery_image) ){
            
            $slider_class = wp_rand();

            $images_id_array = array();
            $images_id_array = explode( ',', $gallery_image );
            
            $output_big_img = $output_small_img = '';

            foreach( $images_id_array as $id ){
                $gallery_full = wp_get_attachment_image_url( $id, 'construction_1130_400' );
                $gallery_thumbnail = wp_get_attachment_image_url( $id, 'construction_311_110' );
                
                $output_big_img .= '<div><a href="'.esc_url( wp_get_attachment_url( $id ) ).'" class="popup"><img src="'.$gallery_full.'" alt="'.esc_html__( 'Project Gallery', 'construction' ).'"></a></div>';
                $output_small_img .= '<div><img src="'.$gallery_thumbnail.'" alt="'.esc_html__( 'Project Gallery', 'construction' ).'"></div>';
            }            

            echo '<div class="slider slider-for'.esc_attr( $slider_class ).'">';
            echo $output_big_img;
            echo '</div>';
            
            echo '<div class="slider slider-nav'.esc_attr( $slider_class ).' slider-thumbnail">';
            echo $output_small_img;
            echo '</div>';
        } ?>
        <script type="text/javascript">
            jQuery(window).load(function(){
                jQuery('.slider-for<?php echo esc_js( $slider_class ); ?>').slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    arrows: false,
                    fade: true,
                    asNavFor: '.slider-nav<?php echo esc_js( $slider_class ); ?>'
                });
                jQuery('.slider-nav<?php echo esc_js( $slider_class ); ?>').slick({
                    slidesToShow: 5,
                    slidesToScroll: 5,
                    arrows: false,
                    asNavFor: '.slider-for<?php echo esc_js( $slider_class ); ?>',
                    dots: false,
                    centerMode: false,
                    focusOnSelect: true
                });
            });
        </script><?php
    } else {
        if( $image_per_view == '0' ){
            $gallery_class_desktop = '1';
            $gallery_class_tablet = '1';
            $gallery_class_mobile = '1';
        } else if( $image_per_view == '1' ){
            $gallery_class_desktop = '2';
            $gallery_class_tablet = '2';
            $gallery_class_mobile = '1';
        } else if( $image_per_view == '2' ){
            $gallery_class_desktop = '3';
            $gallery_class_tablet = '2';
            $gallery_class_mobile = '1';
        } else if( $image_per_view == '3' ){
            $gallery_class_desktop = '4';
            $gallery_class_tablet = '2';
            $gallery_class_mobile = '1';
        } else if( $image_per_view == '4' ){
            $gallery_class_desktop = '6';
            $gallery_class_tablet = '3';
            $gallery_class_mobile = '1';
        }

        $slider_class = wp_rand();
        
        echo '<ul class="bxslider'.esc_attr( $slider_class ).'">';
        
        if( !empty($gallery_image) ){
        
            $images_id_array = array();
            $images_id_array = explode( ',', $gallery_image );
            
            foreach( $images_id_array as $id ){
                echo '<li><a href="'.esc_url( wp_get_attachment_url( $id ) ).'" class="popup"><img src="'.esc_url( wp_get_attachment_url( $id ) ).'" alt="'.esc_html__( 'Service Slider', 'construction' ).'"></a></li>';
            }
        }

        echo '</ul>'; ?>
        <script type="text/javascript">
            jQuery(window).load(function(){
                jQuery('.bxslider<?php echo esc_js( $slider_class ); ?>').bxSlider({
                  slideMargin: 5,
                  autoReload: true,
                  breaks: [{screen:1200, slides:'<?php echo esc_js( $gallery_class_desktop ); ?>', pager:false}, {screen:460, slides:'<?php echo esc_js( $gallery_class_mobile ); ?>', pager:false}, {screen: 768, slides:'<?php echo esc_js( $gallery_class_tablet ); ?>', pager:false}, {screen:280, slides:'<?php echo esc_js( $gallery_class_mobile ); ?>', pager:false}]
                });
            });
        </script><?php
    }

    $output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}

add_shortcode( 'gallery', 'construction_gallery_shortcode' );

?>