<?php

function construction_gmap( $atts, $content = null ){

	extract( shortcode_atts( array(
		'latitude'		=> '40.7127837',
		'longitude'		=> '-74.00594130000002',
		'zoom'			=> '',
		'map_marker'	=> '',
		'marker_icon'	=> '',
		'html'			=> '',
		'scrollwheel'	=> '',
		'maptype'		=> '',
		'width'			=> '',
		'height'		=> '',
	), $atts) );

	global $construction_options;
    
    $google_map_ssl_key  = $construction_options['google_map_ssl_key'];
    $google_map_api_key  = $construction_options['google_map_api_key'];

    if( esc_html( $google_map_ssl_key ) == 'yes' ){
        wp_enqueue_script('google-map', 'https://maps-api-ssl.google.com/maps/api/js?libraries=places&language='.get_locale().'&key='.esc_html( $google_map_api_key ),array('jquery'), '1.0', false);
    } else {
        wp_enqueue_script('google-map', 'http://maps.googleapis.com/maps/api/js?libraries=places&language='.get_locale().'&key='.esc_html( $google_map_api_key ), array('jquery'), '1.0', false);
    }

	$width 	= ($width) ? 'width:'.$width : 'width:100%';
	$height = ($height) ? 'height:'.$height : 'height:500px';

	if( !empty($marker_icon) && is_numeric($marker_icon) ){
		$marker_icon = wp_get_attachment_url( $marker_icon );
    } else {
        $marker_icon = get_template_directory_uri().'/assets/images/map-marker.png';
    }

    $token = wp_generate_password(5, false, false);

   	ob_start(); ?>

	<div id="map<?php echo esc_attr($token); ?>" style="<?php echo esc_attr($width).';'; ?> <?php echo esc_attr($height).';'; ?>"></div>

	<script type="text/javascript">
	jQuery(document).ready(function($){
		var token = '<?php echo esc_js( $token ); ?>';
		var map_marker = '<?php echo esc_js( $map_marker ); ?>';
		var html = '<?php echo esc_js( $html ); ?>';
		
		// Initialize google map
		var map;
		function initialize(){

		  	// Set google map property
		  	var myCenter = new google.maps.LatLng(<?php echo esc_js( $latitude ); ?>, <?php echo esc_js( $longitude ); ?>);
		  	var mapProp = {
		  		scrollwheel: <?php echo esc_js( $scrollwheel ) == 'enable' ? 'true' : 'false' ?>,
		      	center : myCenter,
		      	zoom : <?php echo (empty($zoom)) ? 11 : $zoom ?>,
		      	mapTypeId : google.maps.MapTypeId.<?php echo (empty($maptype)) ? 'ROADMAP' : $maptype ?>,		      	
		  	};
		  	var map = new google.maps.Map(document.getElementById("map"+token), mapProp);
		  	
		  	if( map_marker == 'yes' ){
			  	// Set google map marker
			  	var marker = new google.maps.Marker({
			      	position : myCenter,
			      	icon : '<?php echo esc_js( $marker_icon ); ?>',
			      	title : '<?php echo esc_js( $html ); ?>',
			  	});
				marker.setMap(map);

				if( html != '' ){
					var infowindow = new google.maps.InfoWindow({
	    				content: '<?php echo esc_js( $html ); ?>'
	  				});

					marker.addListener('click', function() {
					    infowindow.open(map, marker);
					});
				}
			}
		}
		// Check google map ID is available or not
		if(document.getElementById("map"+token) != null ){
		  	google.maps.event.addDomListener(window, 'load', initialize);   
		}
	});
	</script><?php

	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}

add_shortcode( 'gmap','construction_gmap' );

?>