<?php

// Construction icon box shortcode
function construction_iconbox_shortcode( $atts, $content = null ){	
	// Extract icon box value
	extract( shortcode_atts( array(
		'icon_type'			=> '',
		'icon_align'		=> '',
		'icon_title'		=> '',		
		'icon_content'		=> '',
		'icon_image'		=> '',
		'bk_icon_image'		=> '',
		'icon_size'			=> '',
		'icon_name'			=> '',
	), $atts ) );

	ob_start();

	// Icon box element is ready to show
	if( $icon_type == 1 ){
		echo '
		<div class="icon-item text-center">
			<div class="icon-outer margin-bottom-30">
	        	<a href="javascript:void(0);">';
		        	if( !empty( $icon_name ) && $icon_name != 'none' ) :
						echo do_shortcode( "[icon name='$icon_name' size='$icon_size']" );
					elseif( !empty( $icon_image) ) :
			        	if( is_numeric( $icon_image ) ){
							$icon_image = wp_get_attachment_url( $icon_image );
						}
						echo '<img src="'.esc_url( $icon_image ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'"/>';
					endif;
	        	echo '
	        	</a>
	      	</div>
	      	<div class="icon-content">
	        	<h5>'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'</h5>
	        	<p>'.sprintf( esc_html__( '%s', 'construction' ), $icon_content ).'</p>
	      	</div>
	    </div>';
	} else if( $icon_type == 2 ){
		echo '
		<div class="about-content-col">
			<div class="about-col-icon">';	        	
	        	if( !empty( $icon_name ) && $icon_name != 'none' ) :
					echo do_shortcode( "[icon name='$icon_name' size='$icon_size']" );
				elseif( !empty( $icon_image) ) :
		        	if( is_numeric( $icon_image ) ){
						$icon_image = wp_get_attachment_url( $icon_image );
					}
					echo '<img src="'.$icon_image.'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'"/>';
				endif;
	        	echo '	        	
	      	</div>
	      	<div class="about-col-right">
	        	<h4>'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'</h4>
	        	<p>'.sprintf( esc_html__( '%s', 'construction' ), $icon_content ).'</p>
	      	</div>
	    </div>';
	} else if( $icon_type == 3 ){
		if( $icon_align == 0 ){
			echo '
			<div class="feature-box feature-box-left">
				<div class="feature-box-icon feature-icon-right">';
					if( !empty( $icon_name ) && $icon_name != 'none' ) :
						echo do_shortcode( "[icon name='$icon_name' size='$icon_size']" );
					elseif( !empty( $icon_image) ) :
			        	if( is_numeric( $icon_image ) ){
							$icon_image = wp_get_attachment_url( $icon_image );
						}
						echo '<img src="'.esc_url( $icon_image ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'"/>';
					endif;
				echo
				'</div>
				<div class="feature-box-text">
					<h4>'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'</h4>
					<p>'.sprintf( esc_html__( '%s', 'construction' ), $icon_content ).'</p>
				</div>
			</div>';
		} else {
			echo '
			<div class="feature-box feature-box-right">
				<div class="feature-box-icon">';
					if( !empty( $icon_name ) && $icon_name != 'none' ) :
						echo do_shortcode( "[icon name='$icon_name' size='$icon_size']" );
					elseif( !empty( $icon_image) ) :
			        	if( is_numeric( $icon_image ) ){
							$icon_image = wp_get_attachment_url( $icon_image );
						}
						echo '<img src="'.esc_url( $icon_image ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'"/>';
					endif;
				echo
				'</div>
				<div class="feature-box-text">
					<h4>'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'</h4>
					<p>'.sprintf( esc_html__( '%s', 'construction' ), $icon_content ).'</p>
				</div>
			</div>';
		}
	} else if( $icon_type == 4 ){
		
		if( is_numeric( $bk_icon_image ) ){
			$bk_icon_image = wp_get_attachment_url( $bk_icon_image );
		}

		echo '
		<div class="highlight-inside">
			<div class="highlight-inside">
                <div class="highlight-blog make-bg" data-background="'.esc_url($bk_icon_image).'">
                    <div class="highlight-up">';
			        	if( !empty( $icon_name ) && $icon_name != 'none' ) :
							echo do_shortcode( "[icon name='$icon_name' size='$icon_size']" );
						elseif( !empty( $icon_image) ) :
				        	if( is_numeric( $icon_image ) ){
								$icon_image = wp_get_attachment_url( $icon_image );
							}
							echo '<img src="'.$icon_image.'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'"/>';
						endif;
			        	echo '
                        <strong>'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'</strong>
                        <span>'.sprintf( esc_html__( '%s', 'construction' ), $icon_content ).'</span>
                    </div>
                </div>
            </div>
        </div>';
	} else {
		echo '
		<div class="icon-custom">';
	    	if( !empty( $icon_name ) && $icon_name != 'none' ) :
				echo do_shortcode( "[icon name='$icon_name' size='$icon_size']" );
			elseif( !empty( $icon_image) ) :
	        	if( is_numeric( $icon_image ) ){
					$icon_image = wp_get_attachment_url( $icon_image );
				}
				echo '<img src="'.$icon_image.'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'"/>';
			endif;
			echo
			'<h6>'.sprintf( esc_html__( '%s', 'construction' ), $icon_title ).'</h6>
	        <h3>'.sprintf( esc_html__( '%s', 'construction' ), $icon_content ).'</h3>
	    </div>';
	}
	
	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'iconbox', 'construction_iconbox_shortcode' );

?>