<?php

// Construction max counter shortcode
function construction_max_counter_shortcode( $atts, $content = null ){	
	// Extract max_counter value
	extract( shortcode_atts( array(
		'counter_type'			=> '',
		'max_counter_number'	=> '',
		'max_counter_label'		=> '',
		'icon_image'			=> '',
		'icon_size'				=> '40px',
		'icon_name'				=> '',
	), $atts ) );

	ob_start();

	// max_counter element is ready to show
	if( $counter_type == 1 ){
		echo '
		<div class="project-count text-center">
			<div class="count-list-inner">
				<div class="project-counter counter-new-style">';
					if( !empty( $icon_name ) && $icon_name != 'none' ) :
						echo do_shortcode( "[icon name='$icon_name' size='$icon_size']" );
					elseif( !empty( $icon_image) ) :
				    	if( is_numeric( $icon_image ) ){
							$icon_image = wp_get_attachment_url( $icon_image );
						}
						echo '<img src="'.esc_url( $icon_image ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $max_counter_label ).'"/>';
					endif;
					echo '<h2 class="timer">'.sprintf( esc_html__( '%s', 'construction' ), $max_counter_number ).'</h2>
					<p>'.sprintf( esc_html__( '%s', 'construction' ), $max_counter_label ).'</p>
				</div>
			</div>
		</div>';		
	} else if( $counter_type == 2 ){
		if( is_numeric( $icon_image ) ){
			$icon_image = wp_get_attachment_url( $icon_image );
		}
		echo '
		<div class="project-count project-count-v3">
			<div class="counter-comunity make-bg" data-background="'.esc_url( $icon_image ).'">
	            <div class="comunity-up">
	                <strong class="timer">'.sprintf( esc_html__( '%s', 'construction' ), $max_counter_number ).'</strong>
	                <span>'.sprintf( esc_html__( '%s', 'construction' ), $max_counter_label ).'</span>
	            </div>
	        </div>
	    </div>';		
	} else {
		echo '
		<div class="project-count text-center">
			<div class="count-list-inner">
				<div class="project-counter">
					<h3 class="timer">'.sprintf( esc_html__( '%s', 'construction' ), $max_counter_number ).'</h3>
					<div class="edge-seprator"></div>
					<p>'.sprintf( esc_html__( '%s', 'construction' ), $max_counter_label ).'</p>
				</div>
			</div>
		</div>';
	}

	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'max_counter', 'construction_max_counter_shortcode' );

?>