<?php

// Construction our clients shortcode
function construction_our_clients_shortcode( $atts, $content = null ){	
	// Extract our clients value
	extract( shortcode_atts( array(
		'client_style'		=> '',
		'client_detail' 	=> '',
		'slider_autoplay'	=> 'true',
		'slider_item'		=> '5',
		'slider_navigation'	=> 'false',
		'slider_pagination'	=> 'false',
		'slider_auto_speed'	=> '1000',
	), $atts ) );

	ob_start();

	$client_detail		= (array) vc_param_group_parse_atts( $client_detail );
	$client_detail_data	= array();

	if( $client_style == 1 ){
		echo '<div class="carousel-box partner-carousel">';
	   	echo '<div class="carousel" data-carousel-autoplay="'.esc_attr( $slider_autoplay ).'" data-carousel-items="'.esc_attr( $slider_item ).'" data-carousel-nav="'.esc_attr( $slider_navigation ).'" data-carousel-pagination="'.esc_attr( $slider_pagination ).'"  data-carousel-speed="'.esc_attr( $slider_auto_speed ).'">';

	   	if( !empty( $client_detail ) ){
		    foreach ( $client_detail as $data ) :
				if( is_numeric($data['client_image']) ){
					$img = wp_get_attachment_url( $data['client_image'] );
				}
				
				if( empty( $data['client_link'] ) ){
					$client_link = 'javascript:void(0);';
				} else {
					$client_link = $data['client_link'];
				}
				
				echo 
				'<div class="carousel-item">
		        	<a href="'.esc_url( $client_link ).'"><img src="'.esc_url( $img ).'" alt="'.esc_html__( 'Our Client', 'construction' ).'"></a>
		        </div>';

			endforeach;
		}

		echo '</div></div>';
	} else {
		echo '
		<section class="test-partner">
	   		<div class="row test-logo-row">';
			   	if( !empty( $client_detail ) ){
				    foreach ( $client_detail as $data ) :
						if( is_numeric($data['client_image']) ){
							$img = wp_get_attachment_url( $data['client_image'] );
						}
						
						if( empty( $data['client_link'] ) ){
							$client_link = 'javascript:void(0);';							
						} else {
							$client_link = $data['client_link'];
						}
						
						echo
						'<div class="col-md-3 col-sm-3 col-xs-6 test-part-logo">
							<a href="'.esc_url( $client_link ).'">
								<img src="'.esc_url( $img ).'" alt="'.esc_html__( 'Our Client', 'construction' ).'">
							</a>
				        </div>';

					endforeach;
				}
			echo '
			</div>
		</section>';
	}

	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'our_clients', 'construction_our_clients_shortcode' );

?>