<?php

// Construction our team shortcode
function construction_our_team_shortcode( $atts, $content = null ){	
	// Extract our team value
	extract( shortcode_atts( array(
		'team_type'			=> '',
		'member_detail'		=> '',		
		'team_style'		=> '',
		'slider_item'		=> 4,
		'slider_autoplay'	=> 'true',
		'slider_navigation'	=> 'false',
		'slider_pagination'	=> 'false',
		'slider_auto_speed'	=> '1000',
	), $atts ) );

	ob_start();

	if( $team_type == 2 ){
		echo '<div class="blog-item-inner our-team-2 text-center">';
		echo '<div class="carousel-box">';
		if( $team_style == 1 ){
			echo '<div class="carousel" data-carousel-autoplay="'.esc_attr( $slider_autoplay ).'" data-carousel-items="'.esc_attr( $slider_item ).'" data-carousel-nav="'.esc_attr( $slider_navigation ).'" data-carousel-pagination="'.esc_attr( $slider_pagination ).'"  data-carousel-speed="'.esc_attr( $slider_auto_speed ).'">';
		}

		$member_detail = (array) vc_param_group_parse_atts( $member_detail );

		if( !empty( $member_detail ) ){
		    foreach( $member_detail as $data ){
				if( is_numeric($data['team_image']) ){
					$img = wp_get_attachment_url( $data['team_image'] );
				}
				
				if( $team_style == 0 ){
					echo '<div class="owl-item col-md-3 col-sm-6 col-xs-12">';
				}
				echo '
				<div class="carousel-item item-team text-center">
					<div class="overlay-wrapper">
						<img src="'.esc_url( $img ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $data['team_name'] ).'">
						<div class="overlay-bg"></div>';
						if( $data['team_social'] == 'enable' ){
							$social1 = $social2 = $social3 = $social4 = '';
							$social1 = ( $data['first_url'] ) ? '<a href="' . esc_url( $data['first_url'] ) . '" target="_blank"><i class="fa fa-' . esc_attr( $data['first_social'] ) . '" aria-hidden="true"></i></a>' : '';
							$social2 = ( $data['second_url'] ) ? '<a href="' . esc_url( $data['second_url'] ) . '" target="_blank"><i class="fa fa-' . esc_attr( $data['second_social'] ) . '" aria-hidden="true"></i></a>' : '';
							$social3 = ( $data['third_url'] ) ? '<a href="' . esc_url( $data['third_url'] ) . '" target="_blank"><i class="fa fa-' . esc_attr( $data['third_social'] ) . '" aria-hidden="true"></i></a>' : '';
							$social4 = ( $data['fourth_url'] ) ? '<a href="' . esc_url( $data['fourth_url'] ) . '" target="_blank"><i class="fa fa-' . esc_attr( $data['fourth_social'] ) . '" aria-hidden="true"></i></a>' : '';
							echo '<div class="overlay-social">'.$social1 . $social2 . $social3 . $social4.'</div>';
						}
					echo '	
					</div>
					<div class="portfolio-item-content">
					<h4>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_name'] ).'</h4>
					<p>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_position'] ).'</p>
				</div>';
					
				echo '</div>';
				if( $team_style == 0 ){
					echo '</div>';
				}			
			}
		}
		
		if( $team_style == 1 ){
			echo '</div>';
		}
		echo '</div></div>';
	} else if( $team_type == 3 ){
		echo '<div class="our-team-3 text-center">';
		echo '<div class="carousel-box">';
		if( $team_style == 1 ){
			echo '<div class="carousel" data-carousel-autoplay="'.esc_attr( $slider_autoplay ).'" data-carousel-items="'.esc_attr( $slider_item ).'" data-carousel-nav="'.esc_attr( $slider_navigation ).'" data-carousel-pagination="'.esc_attr( $slider_pagination ).'"  data-carousel-speed="'.esc_attr( $slider_auto_speed ).'">';
		}

		$member_detail = (array) vc_param_group_parse_atts( $member_detail );

		if( !empty( $member_detail ) ){
		    foreach( $member_detail as $data ){
				if( is_numeric($data['team_image']) ){
					$img = wp_get_attachment_url( $data['team_image'] );
				}
				
				if( $team_style == 0 ){
					echo '<div class="owl-item col-md-4 col-sm-6 col-xs-12">';
				}
				echo '
				<div class="carousel-item item-team text-center">
					<div class="overlay-wrapper">
						<img src="'.esc_url( $img ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $data['team_name'] ).'">
						<div class="overlay-bg"></div>
					</div>
					<div class="portfolio-item-content">
					<h4>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_name'] ).'</h4>
					<p>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_position'] ).'</p>
				</div>';
					
				echo '</div>';
				if( $team_style == 0 ){
					echo '</div>';
				}			
			}
		}
		
		if( $team_style == 1 ){
			echo '</div>';
		}
		echo '</div></div>';
	} else if( $team_type == 4 ){
		$member_detail = (array) vc_param_group_parse_atts( $member_detail );

		if( !empty( $member_detail ) ){
		    foreach( $member_detail as $data ){
				if( is_numeric($data['team_image']) ){
					$img = wp_get_attachment_url( $data['team_image'] );
				}
				
				echo '<div class="text-center"><div class="col-md-3 col-sm-6 col-xs-12">';
				echo '
				<div class="g-team-blog overlay-outer">
					<div class="g-team-img">
	                    <a href="#"><img src="'.esc_url( $img ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $data['team_name'] ).'"></a>
	                    <div class="overlay-bg g-team-overlay">
	                        <div class="g-team-overup">';
	                            if( $data['team_social'] == 'enable' ){
									$social1 = $social2 = $social3 = $social4 = '';
									$social1 = ( $data['first_url'] ) ? '<li><a href="' . esc_url( $data['first_url'] ) . '" target="_blank"><i class="fa fa-' . esc_attr( $data['first_social'] ) . '"></i></a></li>' : '';
									$social2 = ( $data['second_url'] ) ? '<li><a href="' . esc_url( $data['second_url'] ) . '" target="_blank"><i class="fa fa-' . esc_attr( $data['second_social'] ) . '"></i></a></li>' : '';
									$social3 = ( $data['third_url'] ) ? '<li><a href="' . esc_url( $data['third_url'] ) . '" target="_blank"><i class="fa fa-' . esc_attr( $data['third_social'] ) . '"></i></a></li>' : '';
									$social4 = ( $data['fourth_url'] ) ? '<li><a href="' . esc_url( $data['fourth_url'] ) . '" target="_blank"><i class="fa fa-' . esc_attr( $data['fourth_social'] ) . '"></i></a></li>' : '';
									echo '<ul class="g-social">'.$social1 . $social2 . $social3 . $social4.'</ul>';
								}
							echo '                                
	                        </div>
	                    </div>
	                </div>
	                <div class="g-team-info">
	                    <h5>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_name'] ).'</h5>
	                    <small>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_position'] ).'</small>
	                    <p>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_text'] ).'</p>
	                </div>
	            </div>';
					
				echo '</div></div>';				
			}
		}
	} else {
		echo '<div class="carousel-box our-team-1 team-member-carousel">';
		if( $team_style == 1 ){			
		   	echo '<div class="carousel" data-carousel-autoplay="'.esc_attr( $slider_autoplay ).'" data-carousel-items="'.esc_attr( $slider_item ).'" data-carousel-nav="'.esc_attr( $slider_navigation ).'" data-carousel-pagination="'.esc_attr( $slider_pagination ).'"  data-carousel-speed="'.esc_attr( $slider_auto_speed ).'">';
		}

		$member_detail = (array) vc_param_group_parse_atts( $member_detail );

		if( !empty( $member_detail ) ){
		    foreach( $member_detail as $data ){
				if( is_numeric($data['team_image']) ){
					$img = wp_get_attachment_url( $data['team_image'] );
				}
				
				if( $team_style == 0 ){
					echo '<div class="col-md-3 col-sm-6 col-xs-12">';
				}
				echo '
				<div class="testimonials-team-blog margin-top-15 overlay-outer text-center">
					<div class="testimonials-team-profile">
						<img src="'.esc_url( $img ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $data['team_name'] ).'">
						<div class="overlay-bg">
							<div class="team-member-about">
								<p>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_text'] ).'</p>
							</div>
						</div>
					</div>
					<h4>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_name'] ).'</h4>
					<p>'.sprintf( esc_html__( '%s', 'construction' ), $data['team_position'] ).'</p>';

					if( $data['team_social'] == 'enable' ){
						$social1 = $social2 = $social3 = $social4 = '';
						$social1 = ( $data['first_url'] ) ? '<li><a href="' . esc_url( $data['first_url'] ) . '" target="_blank"><i class="fa fa-' . $data['first_social'] . '" aria-hidden="true"></i></a></li>' : '';
						$social2 = ( $data['second_url'] ) ? '<li><a href="' . esc_url( $data['second_url'] ) . '" target="_blank"><i class="fa fa-' . $data['second_social'] . '" aria-hidden="true"></i></a></li>' : '';
						$social3 = ( $data['third_url'] ) ? '<li><a href="' . esc_url( $data['third_url'] ) . '" target="_blank"><i class="fa fa-' . $data['third_social'] . '" aria-hidden="true"></i></a></li>' : '';
						$social4 = ( $data['fourth_url'] ) ? '<li><a href="' . esc_url( $data['fourth_url'] ) . '" target="_blank"><i class="fa fa-' . $data['fourth_social'] . '" aria-hidden="true"></i></a></li>' : '';
						echo '<ul class="pull-social">' . $social1 . $social2 . $social3 . $social4 . '</ul>';						
					}
				echo '</div>';
				if( $team_style == 0 ){
					echo '</div>';
				}			
			}
		}
		
		if( $team_style == 1 ){
			echo '</div>';
		}
		echo '</div>';
	}

	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'our_team', 'construction_our_team_shortcode' );

?>