<?php

function construction_package_shortcode( $atts, $content = null ) {

	extract( shortcode_atts( array(
		'package_title' 	=> '',
		'package_price' 	=> '',
		'package_period' 	=> '',
		'package_features' 	=> '',
		'button_text' 		=> '',
		'button_url' 		=> '',
		'package_featured' 	=> '',
	), $atts ) );

	ob_start();

	$package_features = (array) vc_param_group_parse_atts( $package_features );
	
	$bussiness_class = '';
	if( $package_featured == 'featured' ){
		$bussiness_class = 'bussiness';
	}
	
	echo '
	<div class="table-list-col">
		<div class="table-title '.esc_attr( $bussiness_class ).'">
			<h6>'.sprintf( esc_html__( '%s', 'construction' ), $package_title ).'</h6>
		</div>
		<div class="table-content">
			<h2>'.sprintf( esc_html__( '%s', 'construction' ), $package_price ).'</h2>
			<h5>'.sprintf( esc_html__( '%s', 'construction' ), $package_period ).'</h5>';						
			
			if( !empty($package_features) ){
				echo '<div class="edge-seprator"></div>';
				foreach ( $package_features as $data ) :
					echo '<p>'.sprintf( esc_html__( '%s', 'construction' ), $data['package_feature'] ).'</p>';
				endforeach;
			}
		echo '</div>';

		if( !empty( $button_text ) && !empty( $button_url ) ){
			echo 
			'<div class="text-center">
            	<a href="'.esc_attr($button_url).'" class="btn-orange">'.sprintf( esc_html__( '%s', 'construction' ), $button_text ).'</a>
            </div>';
        }
   		echo '
   	</div>';
	
	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}

add_shortcode( 'package', 'construction_package_shortcode' );

?>