<?php

// Construction projects shortcode
function construction_projects_shortcode( $atts, $content = null ){	
	// Extract projects value
	extract( shortcode_atts( array(
		'project_list_style'	=> '',
		'project_style'			=> '',
		'project_with_space'	=> '',
		'project_view'			=> '',
		'project_per_view'		=> '',
		'project_limit'			=> '',
		'project_ids'			=> '',
		'offset'				=> '',
		'project_zoom'			=> '',
		'project_link'			=> '',
		'project_title'			=> '',
		'project_all_button'	=> '',
		'project_button_text'	=> '',
		'project_button_url'	=> '',
		'orderby'				=> '',
		'order'					=> '',
	), $atts ) );
	
	ob_start();

	$project_special_class = '';
	
	if( $project_per_view == '0' ){
		$grid_class = 'col-md-12 col-sm-12 col-xs-12';
	} else if( $project_per_view == '1' ){
		$grid_class = 'col-md-6 col-sm-6 col-xs-12';
	} else if( $project_per_view == '2' ){
		$project_special_class = 'project-special-class';
		$grid_class = 'col-md-4 col-sm-4 col-xs-12';
	} else if( $project_per_view == '3' ){
		$grid_class = 'col-md-3 col-sm-3 col-xs-12';
	} else if( $project_per_view == '4' ){
		$grid_class = 'col-md-2 col-sm-2 col-xs-12';
	} else {
		$grid_class = 'col-md-4 col-sm-4 col-xs-12';
	}

	$wp_query = array( 'ignore_sticky_posts' => 1 );

	$project_ids_array = explode( ',', $project_ids );

	if( !empty($project_ids) ){
        $wp_query['post__in'] = $project_ids_array;
    }

    $wp_query['post_status'] = 'publish';

    if( empty($project_limit) ){
        $project_limit = get_option( 'posts_per_page' );
    }

    $wp_query['orderby'] = $orderby;

    $wp_query['order'] = $order;

    $wp_query['posts_per_page'] = $project_limit;

	$wp_query['offset'] = $offset ;

	$wp_query['post_type'] = 'project';

	$wp_query['suppress_filters'] = true;

	$the_query = new WP_Query( $wp_query );
		
	$id = uniqid(rand());

	if( $project_with_space == 1 ){
		$with_space_class = 'project-with-space';
	} else {
		$with_space_class = '';
	}

	if( $the_query->have_posts() ) :

		if( $project_list_style == 1 ){
			
			echo '<div class="project-packery">';
			
			if( $project_style == 0 ){
		        echo '<div class="portfolioFilter text-center">';
		    	echo '<a href="javascript:void(0);" data-filter="*" class="current">'.esc_html__( "All", 'construction' ).'</a>';
		        
		        $terms = get_terms( 'projects', array( 'hide_empty' => false ) );
		         
		        if( $terms && ! is_wp_error( $terms ) ) :
		            foreach( $terms as $term ){
		                echo '<a href="javascript:void(0);" data-filter=".'.esc_attr( $term->slug ).'">'.sprintf( esc_html__( '%s', 'construction' ), $term->name ).'</a>';
		            }
		        endif;

		        echo '</div>';
		    }

		    if( $project_view == 1 ){
				echo '<div id="construction-'.esc_attr($id).'" class="portfolioContainer packery-inside">';
			} else {
				echo '<div id="construction-'.esc_attr($id).'" class="portfolioContainer">';
			}	        

			while( $the_query->have_posts() ) : $the_query->the_post();

	        	global $post;
	            
	            $terms = get_the_terms( $post->ID, 'projects' );
	                     
	            if( $terms && ! is_wp_error( $terms ) ) :
	                $project_links = array();
	            	$project_cat = array();
	                foreach ( $terms as $term ) {
	                    $project_links[] = $term->slug;
	                    $project_cat[] = $term->name;
	                }
	                $project = join( " ", $project_links );
	                $project_cat_name = join( ", ", $project_cat );
	            endif;
	        	
	        	$full_image = wp_get_attachment_image_url( get_post_thumbnail_id( $post->ID ), 'full' );

	        	if( $project_view == 1 ){
					echo '<div class="pckItem '.esc_attr( $project ).' '.esc_attr( $with_space_class ).' portfolio-line-list">';
				} else {
					echo '<div class="'.esc_attr( $project ).' '.esc_attr( $grid_class ).' '.esc_attr( $with_space_class ).' portfolio-line-list">';
				}

	        	echo '				
					<div class="overlay-outer">
						<img src="'.esc_url( $full_image ).'" alt="'.esc_attr( $post->post_title ).'">
	                    <div class="pckItem-over overlay-bg">
	                        <div class="pckItem-over-in">';
	                            if( $project_title == 'yes' ){
									echo '<h6>'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'</h6>';
									echo '<i>'.sprintf( esc_html__( '%s', 'construction' ), $project_cat_name ).'</i>';
								}                            
	                            if( $project_zoom == 'yes' ){
									echo '<a href="'.esc_url( $full_image ).'" class="g-zoom" data-lightbox="portfolio"></a>';
								}
								if( $project_link == 'yes' ){
									echo '<a href="'.esc_url( get_the_permalink( $post->ID ) ).'" class="g-link"></a>';
								}
							echo '
	                        </div>
	                    </div>
	                </div>
				</div>';

	        endwhile;

	        echo '</div>';

	        echo '</div>';
			
	        if( $project_all_button == 'yes' ){
				echo 
				'<div class="g-view">
	            	<a href="'.esc_attr($project_button_url).'" class="btn-expert-common btn-expert-black">'.sprintf( esc_html__( '%s', 'construction' ), $project_button_text ).'</a>
	            </div>';
	        }
		} else {
			if( $project_view == 1 ){
				echo '<div class="project-packery-old">';
			}
			
			if( $project_style == 0 ){
		        echo '<div class="portfolioFilter text-center">';
		    	echo '<a href="javascript:void(0);" data-filter="*" class="current">'.esc_html__( "All", 'construction' ).'</a>';
		        
		        $terms = get_terms( 'projects', array( 'hide_empty' => false ) );
		         
		        if( $terms && ! is_wp_error( $terms ) ) :                       
		            foreach( $terms as $term ){
		                echo '<a href="javascript:void(0);" data-filter=".'.esc_attr( $term->slug ).'">'.sprintf( esc_html__( '%s', 'construction' ), $term->name ).'</a>';
		            }
		        endif;

		        echo '</div>';
		    }

		    if( $project_view == 1 ){
	        	echo '<div id="construction-'.esc_attr($id).'" class="portfolioContainer packery-inside-old row '.esc_attr($project_special_class).'">';
	        } else {
	        	echo '<div id="construction-'.esc_attr($id).'" class="portfolioContainer row '.esc_attr($project_special_class).'">';
	        }

	        while( $the_query->have_posts() ) : $the_query->the_post();

	        	global $post;
	            
	            $terms = get_the_terms( $post->ID, 'projects' );
	                     
	            if( $terms && ! is_wp_error( $terms ) ) :                
	                $project_links = array();                 
	                foreach ( $terms as $term ) {
	                    $project_links[] = $term->slug;
	                }
	                $project = join( " ", $project_links );
	            endif;	        	
				
	        	$full_image = wp_get_attachment_image_url( get_post_thumbnail_id( $post->ID ), 'full' );

	        	if( $project_view == 1 ){
					echo '<div class="pckItem-old '.esc_attr( $project ).' '.esc_attr( $with_space_class ).' portfolio-line-list">';
	        	} else {
	        		echo '<div class="'.esc_attr( $project ).' '.esc_attr( $grid_class ).' '.esc_attr( $with_space_class ).' portfolio-line-list">';
	        	}

				echo '
					<div class="overlay-wrapper-content">
						<img src="'.esc_url( $full_image ).'" alt="'.esc_attr( $post->post_title ).'">
						<div class="overlay-details">';
							if( $project_title == 'yes' ){
								echo '<p>'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'</p>';
							}
							if( $project_zoom == 'yes' ){
								echo '<a class="color-white" href="'.esc_url( $full_image ).'" data-lightbox="portfolio"><img src="'.get_template_directory_uri().'/assets/images/project-plus.png" alt="'.esc_html__( 'Plus Sign', 'construction' ).'"/></a>';
							}
							if( $project_link == 'yes' ){
								echo '<a class="color-white" href="'.esc_url( get_the_permalink( $post->ID ) ).'"><img src="'.get_template_directory_uri().'/assets/images/project-link.png" alt="'.esc_html__( 'Plus Link', 'construction' ).'"/></a>';
							}
						echo '
						</div>
						<div class="overlay-bg"></div>
					</div>
				</div>';

	        endwhile;

	        echo '</div>';

	        if( $project_all_button == 'yes' ){
				echo 
				'<div class="view-all text-center">
	            	<a href="'.esc_attr($project_button_url).'" class="btn-orange">'.sprintf( esc_html__( '%s', 'construction' ), $project_button_text ).'</a>
	            </div>';
	        }
	        if( $project_view == 1 ){
				echo '</div>';
			}
	    }
    endif;
	
	wp_reset_postdata();
	
	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'projects', 'construction_projects_shortcode' );

?>