<?php

// Construction services shortcode
function construction_services_shortcode( $atts, $content = null ){	
	// Extract services value
	extract( shortcode_atts( array(
		'service_style'	=> '',
		'service_ids'	=> '',		
		'posts_limit'	=> '',
		'offset'		=> '',
		'show_excerpt'	=> '',
		'number_word'	=> '',
		'orderby'		=> '',
		'order'			=> '',
	), $atts ) );
	
	ob_start();

	$wp_query = array( 'ignore_sticky_posts' => 1 );

	$service_ids_array = explode( ',', $service_ids );

	if( !empty($service_ids) ){
        $wp_query['post__in'] = $service_ids_array;
    }
    
    $wp_query['post_status'] = 'publish';

    if( empty($posts_limit) ){
        $posts_limit = get_option( 'posts_per_page' );
    }

    $wp_query['orderby'] = $orderby;

    $wp_query['order'] = $order;

    $wp_query['posts_per_page'] = $posts_limit;

	$wp_query['offset'] = $offset;

	$wp_query['suppress_filters'] = true;

	$wp_query['post_type'] = 'service';

	$the_query = new WP_Query( $wp_query );
	
	if( $service_style == 1 ){
		// Services element is ready to show
		echo '<div class="services-main-inner eq-blog-main"><div class="row">';

		if( $the_query->have_posts() ) :
			while( $the_query->have_posts() ) : $the_query->the_post();
				global $post;
				
				$service_thumbnail = get_post_meta( $post->ID, 'service_thumbnail', true );
				$service_thumbnail = wp_get_attachment_image_url( $service_thumbnail, 'construction_478_310' );
				
				echo '
				<div class="col-md-4 col-sm-6 col-xs-12">
			      	<div class="services-row-list eq-blog-list overlay-outer margin-bottom-50">
			        	<div class="services-image">
			          		<a href="'.esc_url( get_the_permalink( $post->ID ) ).'">
			            		<img src="'.esc_url( $service_thumbnail ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'">
			            		<div class="overlay-bg"></div>
			          		</a>			          		
			        	</div>
			        	<div class="services-content"><br>
			        		<a href="'.esc_url( get_the_permalink( $post->ID ) ).'"><h4>'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'</h4></a>';
			        		if( $show_excerpt == 'yes' ){
			          			echo '<p>'.sprintf( esc_html__( '%s', 'construction' ), wp_trim_words( $post->post_excerpt, $number_word ) ).'</p>';
			          		} else {
			          			echo '<br>';
			          		}

			          		global $construction_options;
							if( empty( $construction_options['service_readmore_text'] ) ){
								$read_more = esc_html__( 'Read More', 'construction' );
							} else {
								$read_more = $construction_options['service_readmore_text'];
							}
			          		
			          		echo '<a href="'.esc_url( get_the_permalink( $post->ID ) ).'" class="btn-orange">'.$read_more.'</a>
			        	</div>
			      	</div>
			    </div>';
			endwhile;
		endif;
	} else if( $service_style == 2 ){
		// Services element is ready to show
		echo '<div class="services-main-inner eq-blog-main"><div class="row">';

		if( $the_query->have_posts() ) :
			while( $the_query->have_posts() ) : $the_query->the_post();
				global $post;
				
				$service_icon = get_post_meta( $post->ID, 'service_icon', true );
				$service_icon = wp_get_attachment_image_url( $service_icon, 'full' );

				echo '
				<div class="col-md-4 col-sm-6 col-xs-12">
			      	<div class="services-row-list eq-blog-list overlay-outer margin-bottom-50 margin-top-50">
			        	<div class="services-small-icon">
		          			<img src="'.esc_url( $service_icon ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'">
		            		<a href="'.esc_url( get_the_permalink( $post->ID ) ).'"><h4>'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'</h4></a>
			        	</div>
			        	<div class="services-content">';
			        		
			        		if( $show_excerpt == 'yes' ){
			          			echo '<p>'.sprintf( esc_html__( '%s', 'construction' ), wp_trim_words( $post->post_excerpt, $number_word ) ).'</p>';
			          		} else {
			          			echo '<br>';
			          		}

			          		global $construction_options;
							if( empty( $construction_options['service_readmore_text'] ) ){
								$read_more = esc_html__( 'Read More', 'construction' );
							} else {
								$read_more = $construction_options['service_readmore_text'];
							}
			          		
			          		echo '<a href="'.esc_url( get_the_permalink( $post->ID ) ).'" class="btn-orange">'.$read_more.'</a>
			        	</div>
			      	</div>
			    </div>';
			endwhile;
		endif;
	} else if( $service_style == 3 ){
		// Services element is ready to show
		echo '<div class="service-style-v4"><div class="row">';

		if( $the_query->have_posts() ) :
			while( $the_query->have_posts() ) : $the_query->the_post();
				global $post;
				
				$service_icon = get_post_meta( $post->ID, 'service_icon', true );
				$service_icon = wp_get_attachment_image_url( $service_icon, 'full' );

				$service_thumbnail = get_post_meta( $post->ID, 'service_thumbnail', true );
				$service_thumbnail = wp_get_attachment_image_url( $service_thumbnail, 'construction_370_190' );

				echo '
				<div class="col-md-4 col-sm-4 col-xs-12">
					<div class="boxer-attend">
	                    <div class="boxer-attend-img">
						    <a href="'.esc_url( get_the_permalink( $post->ID ) ).'">
						        <img src="'.esc_url($service_thumbnail).'" alt="'.esc_attr($post->post_title).'">
						        <div class="boxer-on-over">
						            <div class="boxer-icon-wp-inside">
						                <div class="boxer-icon-wp">
						                    <img src="'.esc_url($service_icon).'" alt="'.esc_attr($post->post_title).'">
						                </div>
						            </div>
						        </div>
						    </a>
						</div>
	                    <div class="boxer-attend-info">
	                        <a href="'.esc_url( get_the_permalink( $post->ID ) ).'"><h4>'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'</h4></a>';
	                        if( $show_excerpt == 'yes' ){
			          			echo '<p>'.sprintf( esc_html__( '%s', 'construction' ), wp_trim_words( $post->post_excerpt, $number_word ) ).'</p>';
			          		} else {
			          			echo '<br>';
			          		}
	                        echo '<p><a href="'.esc_url( get_the_permalink( $post->ID ) ).'" class="xs-arrow"></a></p>
	                    </div>
	                </div>
	            </div>';
			endwhile;
		endif;
	} else {
		// Services element is ready to show
		echo '<div class="services-main-inner eq-blog-main"><div class="row">';

		if( $the_query->have_posts() ) :
			while( $the_query->have_posts() ) : $the_query->the_post();
				global $post;
				
				$service_icon = get_post_meta( $post->ID, 'service_icon', true );
				$service_icon = wp_get_attachment_image_url( $service_icon, 'full' );

				$service_thumbnail = get_post_meta( $post->ID, 'service_thumbnail', true );
				$service_thumbnail = wp_get_attachment_image_url( $service_thumbnail, 'construction_370_140' );
				
				echo '
				<div class="col-md-4 col-sm-6 col-xs-12">
			      	<div class="services-row-list eq-blog-list overlay-outer margin-bottom-50">
			        	<div class="services-small-icon">
			          		<a href="'.esc_url( get_the_permalink( $post->ID ) ).'"><img src="'.esc_url( $service_icon ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'"></a>
			          		<h5>'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'</h5>
			        	</div>
			        	<div class="services-image">
			          		<a href="'.esc_url( get_the_permalink( $post->ID ) ).'">
			            		<img src="'.esc_url( $service_thumbnail ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $post->post_title ).'">
			            		<div class="overlay-bg"></div>
			          		</a>
			        	</div>
			        	<div class="services-content">';
			        		if( $show_excerpt == 'yes' ){
			          			echo '<p>'.sprintf( esc_html__( '%s', 'construction' ), wp_trim_words( $post->post_excerpt, $number_word ) ).'</p>';
			          		} else {
			          			echo '<br>';
			          		}

			          		global $construction_options;
							if( empty( $construction_options['service_readmore_text'] ) ){
								$read_more = esc_html__( 'Read More', 'construction' );
							} else {
								$read_more = $construction_options['service_readmore_text'];
							}
			          		
			          		echo '<a href="'.esc_url( get_the_permalink( $post->ID ) ).'" class="btn-orange">'.$read_more.'</a>
			        	</div>
			      	</div>
			    </div>';
			endwhile;
		endif;
	}

	wp_reset_postdata();
	
	echo '</div></div>';

	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'services', 'construction_services_shortcode' );

?>