<?php

function construction_testimonials_shortcode( $atts, $content = null ) {

	extract( shortcode_atts( array(
		'testimonials_style'	=> '',
		'testimonial' 			=> '',
		'slider_item'			=> 3,
		'slider_autoplay'		=> 'true',
		'slider_navigation'		=> 'false',
		'slider_pagination'		=> 'false',
		'slider_auto_speed'		=> '1000',			
	), $atts ) );

	ob_start();

	$testimonial		= (array) vc_param_group_parse_atts( $testimonial );
	$testimonial_data	= array();

	if( $testimonials_style == 1 ){
		echo '
		<div class="testimonial-long-list">
			<div class="carousel-box">
				<div class="carousel" data-carousel-autoplay="'.esc_attr( $slider_autoplay ).'" data-carousel-items="'.esc_attr( $slider_item ).'" data-carousel-nav="'.esc_attr( $slider_navigation ).'" data-carousel-pagination="'.esc_attr( $slider_pagination ).'"  data-carousel-speed="'.esc_attr( $slider_auto_speed ).'">';
				if( !empty( $testimonial ) ){
					foreach ( $testimonial as $data ) :
						if( is_numeric( $data['customer_image'] ) ){
							$img = wp_get_attachment_url( $data['customer_image'] );		
						}
						echo
						'<div class="carousel-item">
							<div class="testimonial-short-col">
								<div class="testimonial-client-info">
                                	<div class="client-img">
                                  		<img src="'.esc_url( $img ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_name'] ).'" class="radius-100">
                                	</div>
                                	<div class="client-content">
                                  		<h6>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_name'] ).'</h6>
                                  		<span>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_position'] ).'</span>
                                	</div>
                              	</div>
                              	<div class="testimonial-detail">
                                	<p>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_say'] ).'</p>
                              	</div>
							</div>
						</div>';		
					endforeach;
				}
				echo '
				</div>
			</div>
		</div>';
	} else if( $testimonials_style == 2 ){
		echo '
		<div class="carousel-box g-testimonial-slider">
			<div class="carousel" data-carousel-autoplay="'.esc_attr( $slider_autoplay ).'" data-carousel-items="'.esc_attr( $slider_item ).'" data-carousel-nav="true" data-carousel-pagination="false" data-carousel-speed="'.esc_attr( $slider_auto_speed ).'">';
			if( !empty( $testimonial ) ){
				foreach ( $testimonial as $data ) :
					if( is_numeric( $data['customer_image'] ) ){
						$img = wp_get_attachment_url( $data['customer_image'] );		
					}
					echo'
                    <div class="carousel-item">
                        <blockquote><sup>“</sup>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_say'] ).'<sub>”</sub></blockquote>
                        <div class="g-testimonial-special">
                            <div class="g-testimonial-img">
                                <img src="'.esc_url( $img ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_name'] ).'" class="radius-100">
                            </div>
                            <div class="g-testimonial-info">
                                <h5>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_name'] ).'</h5>
                                <small>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_position'] ).'</small>
                            </div>
                        </div>
                    </div>';		
				endforeach;
			}
			echo '
			</div>
		</div>';
	} else {
		echo '<div id="testimonial_carosule" class="owl-carousel owl-theme text-center">';
		if( !empty( $testimonial ) ){
			foreach ( $testimonial as $data ) :
				if( is_numeric( $data['customer_image'] ) ){
					$img = wp_get_attachment_url( $data['customer_image'] );		
				}
				echo
				'<div class="item"> 
					<blockquote>
						<img src="'.esc_url( $img ).'" alt="'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_name'] ).'" class="radius-100">
						<h5>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_name'] ).'</h5>
						<h6>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_position'] ).'</h6>
						<p><i>'.sprintf( esc_html__( '%s', 'construction' ), $data['customer_say'] ).'</i></p>
					</blockquote>  
				</div>';		
			endforeach;
		}
		echo '</div>';
	}

	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}

add_shortcode( 'testimonials', 'construction_testimonials_shortcode' );

?>