<?php

// Construction video popup shortcode
function construction_video_popup_shortcode( $atts, $content = null ){	
	// Extract video popup value
	extract( shortcode_atts( array(
		'video_link'				=> '',
		'video_placeholer_image'	=> '',		
	), $atts ) );

	ob_start();

	$img = '';
	
	if( is_numeric( $video_placeholer_image ) )
		$img = wp_get_attachment_url( $video_placeholer_image );

	// Video popup element is ready to show
	echo '
	<div class="video-popup-outer-v4">
		<a href="'.esc_url( $video_link ).'" class="video-popup play-btn"></a>
		<a href="'.esc_url( $video_link ).'" class="video-popup popup-over"><img src="'.esc_url( $img ).'" alt="'.esc_html__( 'Video Popup', 'construction' ).'" class="f-width"></a>
	</div>';
	
	$output = ob_get_contents();
        
    ob_end_clean();

    return $output;
}
add_shortcode( 'video_popup', 'construction_video_popup_shortcode' );

?>