<?php

// Register Project custom post type
if( !function_exists( 'construction_project_custom_post' ) ){

    function construction_project_custom_post(){
        // Set Project post type labels
        $labels = array(
            'name'                  => esc_html__( 'Project', 'construction' ),
            'singular_name'         => esc_html__( 'Project', 'construction' ),
            'add_new'               => esc_html__( 'Add New Project', 'construction' ),
            'add_new_item'          => esc_html__( 'Add New Project', 'construction' ),
            'edit_item'             => esc_html__( 'Edit Project', 'construction' ),
            'new_item'              => esc_html__( 'New Project', 'construction' ),
            'view_item'             => esc_html__( 'View Project', 'construction' ),
            'search_items'          => esc_html__( 'Search Project', 'construction' ),
            'not_found'             => esc_html__( 'No Project found', 'construction' ),
            'not_found_in_trash'    => esc_html__( 'No Project found in Trash', 'construction' ),
        );

        // Set Project post type compatibility
        $args = array(
            'labels'                => $labels,
            'public'                => true,
            'exclude_from_search'   => true,
            'publicly_queryable'    => true,
            'show_ui'               => true,
            'query_var'             => true,
            'capability_type'       => 'post',
            'hierarchical'          => false,
            'menu_icon'             => 'dashicons-admin-post',
            'supports'              => array( 'title', 'editor', 'thumbnail', 'page-attributes', 'excerpt' ),
            'rewrite'               => array( 'slug' => 'project' )
        );
        
        // Register Service custom post type
        register_post_type( 'project', $args );
    }

}
add_action( 'init', 'construction_project_custom_post' );

// Register taxonomies for project custom post
if( !function_exists( 'construction_project_category' ) ){

    function construction_project_category(){
        // Register project label taxonomy for project
        register_taxonomy('projects', 'project', 
              array(
                    'labels' => array(
                          'name'              => esc_html__( 'Project Category', 'construction' ),
                          'add_new_item'      => esc_html__( 'Add New Project', 'construction' ),
                          'new_item_name'     => esc_html__( 'New Project', 'construction' )
                    ),
                    'hierarchical'  => true,
                    'query_var'     => true,
                    'rewrite'       => array( 'slug' => 'projects' )
              )
        );
    }
}
add_action( 'init', 'construction_project_category', 0 );

// Get project taxonomy name
if( ! function_exists ( 'construction_get_taxonomy' ) ){

    function construction_get_taxonomy( $project_id, $category, $post_type ){
        // Get the project taxonomy
        $terms = get_the_terms( $project_id, $category );
        if( ! empty ( $terms ) ){
            $result = array();            
            foreach( $terms as $term ){
                $result[] = sprintf( '<a href="%s">%s</a>',
                    esc_url( add_query_arg( array( 'post_type' => $post_type, $category => $term->slug ), 'edit.php' ) ),
                    esc_html( sanitize_term_field( 'name', $term->name, $term->term_id, $category, 'display' ) )
                );
            }            
            return join( ', ', $result );
        }
        return false;
    }
}

// Add column in project list page
if( !function_exists( 'construction_add_project_columns' ) ){
    
    function construction_add_project_columns($columns){
        // Set column name
        $columns = array(
            'cb'            => '<input type=\'checkbox\' />',
            'title'         => esc_html__( 'project Title', 'construction' ),
            'project_photo' => esc_html__( 'Thumbnail', 'construction' ),
            'project_type'  => esc_html__( 'Category', 'construction' ),
            'date'          => esc_html__( 'Publish Time', 'construction' )
        );
        return $columns;
    }
}
add_filter( 'manage_edit-project_columns', 'construction_add_project_columns' );

// Show column in project list page
if( !function_exists( 'construction_show_project_columns' ) ){

    function construction_show_project_columns($column){

        global $post;        
        
        // Check column and add in project list page
        switch ($column){            
            case 'project_photo':
                if( has_post_thumbnail($post->ID) ){ ?>
                    <a href="<?php the_permalink(); ?>" target="_blank"><?php the_post_thumbnail( array( 100, 100 ) ); ?></a><?php
                } else {
                    esc_html_e( '-', 'construction' );
                }
            break;

            case 'project_type':
                echo construction_get_taxonomy( $post->ID, 'projects', 'project' );
            break;
        }
    }
}
add_action( 'manage_project_posts_custom_column', 'construction_show_project_columns' );

?>