<?php

// Register Service custom post type
if( !function_exists( 'construction_service_custom_post' ) ){

    function construction_service_custom_post(){
        // Set Service post type labels
        $labels = array(
            'name'                  => esc_html__( 'Service', 'construction' ),
            'singular_name'         => esc_html__( 'Service', 'construction' ),
            'add_new'               => esc_html__( 'Add New Project', 'construction' ),
            'add_new_item'          => esc_html__( 'Add New Service', 'construction' ),
            'edit_item'             => esc_html__( 'Edit Service', 'construction' ),
            'new_item'              => esc_html__( 'New Service', 'construction' ),
            'view_item'             => esc_html__( 'View Service', 'construction' ),
            'search_items'          => esc_html__( 'Search Service', 'construction' ),
            'not_found'             => esc_html__( 'No Service found', 'construction' ),
            'not_found_in_trash'    => esc_html__( 'No Service found in Trash', 'construction' ),
        );

        // Set Service post type compatibility
        $args = array(
            'labels'                => $labels,
            'public'                => true,
            'exclude_from_search'   => true,
            'publicly_queryable'    => true,
            'show_ui'               => true,
            'query_var'             => true,
            'capability_type'       => 'post',
            'hierarchical'          => false,
            'menu_icon'             => 'dashicons-admin-multisite',
            'supports'              => array( 'title', 'editor', 'page-attributes', 'excerpt','thumbnail'),
            'rewrite'               => array( 'slug' => 'service' )
        );
        
        // Register Service custom post type
        register_post_type( 'service', $args );
    }

}
add_action( 'init', 'construction_service_custom_post' );

// Add column in service list page
if( !function_exists( 'construction_add_service_column' ) ){
    
    function construction_add_service_column($columns){
        // Set column name
        $columns = array(
            'cb'            => '<input type=\'checkbox\' />',
            'title'         => esc_html__( 'Name', 'construction' ),
            'photo'         => esc_html__( 'Thumbnail', 'construction' ),
            'icon'          => esc_html__( 'Icon', 'construction' ),
            'date'          => esc_html__( 'Publish Time', 'construction' )
        );
        return $columns;
    }
}
add_filter( 'manage_edit-service_columns', 'construction_add_service_column' );

// Show column in service list page
if( !function_exists( 'construction_show_service_column' ) ){

    function construction_show_service_column($column){

        global $post;
        
        // Get service details
        $service_thumbnail  = get_post_meta( $post->ID, 'service_thumbnail', true );        
        $service_icon       = get_post_meta( $post->ID, 'service_icon', true );
        
        // Check column and add in service list page
        switch ($column){
            case 'photo':
                if( !empty($service_thumbnail) ){
                    $service_thumbnail = wp_get_attachment_image_src( $service_thumbnail );
                    if ( $service_thumbnail ) : ?>
                        <img src="<?php echo $service_thumbnail[0]; ?>" width="100px" height="100px" />
                    <?php endif;
                } else {
                    esc_html_e( '-', 'construction' );
                }
            break;

            case 'icon':
                if( !empty($service_icon) ){
                    $service_icon = wp_get_attachment_image_src( $service_icon );
                    if ( $service_icon ) : ?>
                        <img src="<?php echo $service_icon[0]; ?>" style="margin-top:35px;" width="30px" height="30px" />
                    <?php endif;
                } else {
                    esc_html_e( '-', 'construction' );
                }
            break;           
        }
    }
}
add_action( 'manage_service_posts_custom_column', 'construction_show_service_column' );

?>